' **********************************************************
' * firgen.bas
' **********************************************************
' * (c) 1995,1996 Gerrit Polder, PA3BYA
' * version 2.0
' *
' * nonrecursive filter design by fourier transform method
' * with rectangular, von hann, or hamming window
' * and decibel plot of frequency responce magnitude
' * with output to TI DSK source file and
' * AD EZ-Kit Lite FIRDEMO .dat file
' * adapted from:
' *       Paul A. Lynn and Wolfgang Fuerst
' *       Introductory Digital Signal Processing
' *
' *       and
' *
' *       FIR Windowed Filter Design Program - WINDOW
' *       L. R. Rabiner, C. A. McGonegal and D. Paul
' *       Programs for Digital Signal Processing, IEEE 1979,
' *       Chapter 5.2
' **********************************************************
' * history:
' * 4/3/95 created
' * 5/8/96 adapted to Visual Basic
' * 28/8/96 added support for EZ-Kit Lite
' **********************************************************
    Dim see(1024), h0, h(1024), w(1024), max
    Dim hint(1024) As Integer, hint0 As Integer
    Dim lowcf, upcf, samplef
    Dim ntaps As Integer, m As Integer
    Dim filtertype As String
    Dim windowtype As String

    Global Filename As String ' This variable keeps track of the filename information for opening and closing files.
    Const MB_YESNO = 4, MB_ICONQUESTION = 32, IDNO = 7, MB_DEFBUTTON2 = 256

Sub compute_freq_response ()

    ' this routine calculates the frequency response from
    ' the impulse response.
    ' Then the frequency response is plotted in the main window.
    ' Calculating the frequency response is time comsuming, therefore
    ' it is done only for 300 points, which is enough to plot it on
    ' the screen.

    npoints = 300
    pi = 4 * Atn(1)
    m = frmNewfil.Text1 \ 2
    
    frmMain.ForeColor = RGB(255, 0, 0)      ' impulse response red?
    frmMain.DrawWidth = 1
    
    ' calculate frequency response
    For n = 1 To npoints
        freq = (pi * (n - 1)) / npoints
        w(n) = h0
        For k = 1 To m
            w(n) = w(n) + 2 * h(k) * Cos(k * freq)
        Next k
    Next n
        
    ' set start coordinate for plot
    frmMain.CurrentX = 400
    Select Case frmNewfil.Combo1
      Case "Low Pass"
        frmMain.CurrentY = 2400
      Case "High Pass"
        frmMain.CurrentY = 4600
      Case "Band Pass"
        frmMain.CurrentY = 4600
      Case "Band Stop"
        frmMain.CurrentY = 2400
    End Select

    ' normalise to unity, convert to decibels, and plot
    max = 0
    For n = 1 To npoints
        If Abs(w(n)) > max Then max = Abs(w(n))
    Next n

    For n = 1 To npoints
        db = 20 * Log(Abs(w(n)) / max) * .4343
        If db < -70 Then db = -70
        frmMain.Line -(400 + (n / npoints) * 5000, 4600 - ((70 + db) / 70) * 2200)
    Next n

End Sub

Sub compute_impulse_response ()
    
    ' this routine calculates the impulse response, which
    ' are the value's for the filter taps
    ' since the DSK and EZ-Kit lite are integer DSP's (16 bit)
    ' the impulse response is also mapped to 16 bit to get
    ' hold of the finite wordlength effects.
    ' If we use these values to calculate and plot the frequency
    ' response, we get the real response, which is also obtained
    ' by the real DSP.

    frmMain.ForeColor = RGB(255, 0, 0)      ' impulse response red?
    frmMain.DrawWidth = 2
    
    ' get parameters
    samplef = frmNewfil.Text4
    ntaps = frmNewfil.Text1
    s = samplef / 2 ' rem shannon
    pi = 4 * Atn(1)
    m = ntaps \ 2
    filtertype = frmNewfil.Combo1
    
    ' calcultae w0, w1, h0 etc for each filter type
    Select Case filtertype
      Case "Low Pass"
        w0 = 0
        w1 = frmNewfil.Text3 * pi / s
        factor = 1
        h0 = w1 / pi
        lowcf = 0
        upcf = frmNewfil.Text3
      Case "High Pass"
        w0 = pi
        w1 = (s - frmNewfil.Text2) * pi / s
        factor = 1
        h0 = w1 / pi
        lowcf = frmNewfil.Text2
        upcf = samplef / 2
      Case "Band Pass"
        w0 = (frmNewfil.Text2 + ((frmNewfil.Text3 - frmNewfil.Text2) / 2)) * pi / s
        w1 = (frmNewfil.Text3 - frmNewfil.Text2) * .5 * pi / s
        factor = 1
        h0 = w1 / pi
        lowcf = frmNewfil.Text2
        upcf = frmNewfil.Text3
      Case "Band Stop"
        w0 = (frmNewfil.Text2 + ((frmNewfil.Text3 - frmNewfil.Text2) / 2)) * pi / s
        w1 = (frmNewfil.Text3 - frmNewfil.Text2) * .5 * pi / s
        factor = -1
        h0 = .5 - w1 / pi
        lowcf = frmNewfil.Text2
        upcf = frmNewfil.Text3
    End Select

    ' calculate impulse response
    maxh = h0
    For n = 1 To m
         h(n) = (factor / (n * pi)) * Sin(n * w1) * Cos(n * w0) * see(n)
         If maxh < h(n) Then
            maxh = h(n)
         End If
    Next n
    
    ' convert impulse response values to 16 bit int
    ' and back to unity (-1.0 - 1.0) this is because of the
    ' finite wordlength error in the 16 bit integer dsp's

    h0 = Int(h0 * 2 ^ 15) / 2 ^ 15
    For n = 1 To m
        h(n) = Int(h(n) * 2 ^ 15) / 2 ^ 15
    Next n

    ' plot impulse response
    frmMain.Line (2900, 1100)-(2900, 1100 - (h0 / maxh) * 1000)

    For n = 1 To m
        frmMain.Line (2900 + (n / m) * 2500, 1100)-(2900 + (n / m) * 2500, 1100 - (h(n) / maxh) * 1000)
        frmMain.Line (2900 - (n / m) * 2500, 1100)-(2900 - (n / m) * 2500, 1100 - (h(n) / maxh) * 1000)
    Next n
            
    
    frmMain.ForeColor = RGB(0, 0, 0)      ' text black

    frmMain.CurrentX = 100
    frmMain.CurrentY = 100
    frmMain.Print maxh
    frmMain.CurrentX = 100
    frmMain.CurrentY = 1000
    frmMain.Print 0
    frmMain.CurrentX = 100
    frmMain.CurrentY = 2000
    frmMain.Print -maxh

    

End Sub

Sub compute_window ()
    
    ' calculate the window (see literature)
    m = frmNewfil.Text1 \ 2    ' taps / 2
    pi = 4 * Atn(1)            ' pi = 3.145.............
    
    windowtype = frmNewfil.Combo2

    Select Case windowtype
      Case "Rectangular"
        a = 1: b = 0: c = 1
      Case "von Hann"
        a = .5: b = .5: c = m + 1
      Case "Hamming"
        a = .54: b = .46: c = m
    End Select

    For n = 1 To m:
        see(n) = a + b * Cos(n * pi / c):
    Next n


End Sub

Sub DoUnLoadPreCheck (unloadmode As Integer)
    If unloadmode = 0 Or unloadmode = 3 Then
            Unload frmAbout
            Unload frmMain
            Unload frmNewfil
            End
    End If
End Sub

Sub drawaxis ()
    
    frmMain.Cls
    ' draw axis
    frmMain.ForeColor = RGB(0, 0, 0)        ' axis black
    frmMain.DrawWidth = 1

    frmMain.Line (400, 100)-(400, 2100)
    frmMain.Line (400, 2400)-(400, 4600)
    frmMain.Line (400, 1100)-(5400, 1100)
    frmMain.Line (400, 4600)-(5400, 4600)
    
    'draw tickmarks
    For i = 400 To 5400 Step 500
        frmMain.Line (i, 1100)-(i, 1200)
        frmMain.Line (i, 4600)-(i, 4700)
        If i > 400 Then
            frmMain.CurrentX = i - 100
            frmMain.CurrentY = 1200
            frmMain.Print (i - 400) * frmNewfil.Text1 / 5000
        End If
        frmMain.CurrentX = i - 100
        frmMain.CurrentY = 4700
        frmMain.Print (i - 400) * frmNewfil.Text4 / 10000
    Next
            
    For i = 0 To 7
            frmMain.CurrentX = 100
            frmMain.CurrentY = 2400 + i * 300
            frmMain.Print -10 * i
    Next i
        
    frmMain.ForeColor = RGB(0, 0, 255)      ' band blue or maybe blue band?
    Select Case frmNewfil.Combo1
      Case "Low Pass"
        frmMain.Line (400, 2400)-(400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 2400)
        frmMain.Line (400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 2400)-(400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 4600)
        frmMain.Line (400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 4600)-(5400, 4600)
      Case "High Pass"
        frmMain.Line (400, 4600)-(400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 4600)
        frmMain.Line (400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 2400)-(400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 4600)
        frmMain.Line (400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 2400)-(5400, 2400)
 
      Case "Band Pass"
        frmMain.Line (400, 4600)-(400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 4600)
        frmMain.Line (400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 2400)-(400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 4600)
        frmMain.Line (400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 2400)-(400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 2400)
        frmMain.Line (400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 2400)-(400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 4600)
        frmMain.Line (400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 4600)-(5400, 4600)
 
      Case "Band Stop"
        frmMain.Line (400, 2400)-(400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 2400)
        frmMain.Line (400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 2400)-(400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 4600)
        frmMain.Line (400 + (frmNewfil.Text2 / frmNewfil.Text4) * 10000, 4600)-(400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 4600)
        frmMain.Line (400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 2400)-(400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 4600)
        frmMain.Line (400 + (frmNewfil.Text3 / frmNewfil.Text4) * 10000, 2400)-(5400, 2400)
 
    End Select
End Sub

Sub save_taps_ad (Filename As String)

    ' save the filtertaps in a file which can be used with
    ' the EZ-Kit Lite FIRDEMO program.
    ' since Basic is not so powerfull as for instance printf in c
    ' this code is somewhat tricky

Dim F As Integer
On Error GoTo CloseError1                ' If there is an error, display the error message below.
    

    If Dir(Filename) <> "" Then         ' File already exists, so ask if overwriting is desired.
        response = MsgBox("Overwrite existing file?", MB_YESNO + MB_QUESTION + MB_DEFBUTTON2)
        If response = IDNO Then Exit Sub
    End If
    F = FreeFile
    Open Filename For Output As F       ' Otherwise, open the file name for output.
    
    factor = 8192
    
    For n = 1 To m: hint(n) = Int(h(n) * factor / max): Next n
    hint0 = Int(h0 * factor / max)
    For n = 1 To m
        For i = 1 To (4 - Len(Hex$(hint(m - (n - 1)))))
            Print #F, "0";
        Next i
        Print #F, Hex$(hint(m - (n - 1))); "00"
    Next n
    For i = 1 To (4 - Len(Hex$(hint0)))
           Print #F, "0";
    Next i
    Print #F, Hex$(hint0); "00"
    For n = 1 To m
        For i = 1 To (4 - Len(Hex$(hint(n))))
            Print #F, "0";
        Next i
        Print #F, Hex$(hint(n)); "00"
    Next n
    
    Close #F
    Filename = "Untitled" ' Reset the caption of the main form
    Exit Sub
CloseError1:
    MsgBox "Error occurred trying to close file, please retry.", 48
    Exit Sub
End Sub

Sub save_taps_ti (Filename As String)
    
    ' save the filtertaps in a file which can be used with
    ' the TI DSK FIR program.
    ' since Basic is not so powerfull as for instance printf in c
    ' this code is somewhat tricky

Dim F As Integer
On Error GoTo CloseError                ' If there is an error, display the error message below.
    
    If Dir(Filename) <> "" Then         ' File already exists, so ask if overwriting is desired.
        response = MsgBox("Overwrite existing file?", MB_YESNO + MB_QUESTION + MB_DEFBUTTON2)
        If response = IDNO Then Exit Sub
    End If
    F = FreeFile
    Open Filename For Output As F       ' Otherwise, open the file name for output.
    
    Print #F, "* coefficents file written by Firgen"
    Print #F, "* (c) 1996 G. Polder, PA3BYA"
    Print #F, "* "; Date$, Time$
    Print #F, "*"
    Print #F, "* sample frequency: ", Format(samplef, "#.##0")
    Print #F, "* lower cutoff frequency: ", Format(lowcf, "#.##0")
    Print #F, "* upper cutoff frequency: ", Format(upcf, "#.##0")
    Print #F, "* number of taps: ", Format(ntaps, "#")
    Print #F, "* window:", , windowtype; " window"
    Print #F, "* filter:", , filtertype; " filter"
    Print #F, "*"
    Print #F, "* impulse response:"
    For n = 1 To m
        Print #F, Format(n - 1, """* h(""##0"") = """),
        Print #F, Format(h(m - (n - 1)) / max, " 0.00000E+00;-0.00000E+00"),
        Print #F, Format(ntaps - n, """ = h(""##0"")""")
    Next n
    Print #F, Format(m, """* h(""##0"") = """),
    Print #F, Format(h0 / max, " 0.00000E+00;-0.00000E+00"),
    Print #F, Format(m, """ = h(""##0"")""")
    Print #F, "*"
    Print #F, "* setting of filtersize"
    Print #F, "FILT_SIZE   .set      "; ntaps
    Print #F, "*"
    Print #F, "* filter coefficients"
    factor = 32768
    For n = 1 To m: hint(n) = Int(h(n) * factor / max): Next n
    hint0 = Int(h0 * factor / max)
    For n = 1 To m
        Print #F, Format(n - 1, "\h#0"), ".word", Str$(hint(m - (n - 1)))
    Next n
    Print #F, Format(m, "\h#0"), ".word", Str$(hint0)
    For n = 1 To m - 1
        Print #F, Format(m + n, "\h#0"), ".word", Str$(hint(n))
    Next n
    Print #F, "H_LAST", ".word", Str$(hint(m))
    Print #F, "*"
    Print #F, "* data locations for stage delay line"
    i = 0
    While i <> ntaps - 1
        Print #F, Format(Int(i / 10), """XN""0"), ".word",
        For n = 1 To 10: Print #F, "0";
            i = i + 1
            If i = ntaps - 1 Then GoTo exitloop
            If n <> 10 Then Print #F, ",";
        Next n
        Print #F, ""
exitloop:
    Wend
    Print #F, ""
    Print #F, "XNLAST", ".word", "0"
    
    Close #F
    Filename = "Untitled" ' Reset the caption of the main form
    Exit Sub
CloseError:
    MsgBox "Error occurred trying to close file, please retry.", 48
    Exit Sub

End Sub

